<?php

/* -----------------------------------------------------------------
 * 	$Id: piazza_ch.php 717 2013-11-05 15:38:31Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	(c) 2013     Gambio GmbH - www.gambio.de
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */

class Piazza_ch {

    var $v_export_type;
    var $v_module_name;
    var $v_module_homepage;
    var $v_module_format;
    var $v_module_export_filename;
    var $v_filename;
    var $v_keyname;
    var $v_linkname;
    var $v_delimiter;
    var $v_enclosure;
    var $v_field_filename;
    var $v_field_customers_groups;
    var $v_field_currency;
    var $v_field_shipping_costs;
    var $v_field_shipping_costs_free;
    var $v_field_attributes;
    var $v_field_campaign;
    var $v_field_export;

    function Piazza_ch() {
        $this->formSettings();
    }

    function formSettings() {
        $this->v_export_type = 'comparison';
        $this->v_module_name = 'Piazza.ch';
        $this->v_module_homepage = 'www.piazza.ch';
        $this->v_module_format = 'csv';
        $this->v_module_export_filename = 'piazza.csv';
        $this->v_filename = 'piazza_ch.php';
        $this->v_keyname = 'PIAZZA';
        $this->v_linkname = 'piazza';
        $this->v_delimiter = ';';
        $this->v_enclosure = '"';
        $this->v_field_filename = true;
        $this->v_field_customers_groups = true;
        $this->v_field_currency = true;
        $this->v_field_shipping_costs = true;
        $this->v_field_shipping_costs_free = true;
        $this->v_field_attributes = true;
        $this->v_field_campaign = true;
        $this->v_field_export = true;
    }

    function formAddOn() {
        
    }

    function formatResults($p_products_array) {
        $p_products_array['products_price'] = number_format((double) $p_products_array['products_price'], 2, ',', '');
        $p_products_array['products_shipping_costs'] = number_format((double) $p_products_array['products_shipping_costs'], 2, ',', '');
        return($p_products_array);
    }

    function exportScheme() {
        $t_csv_fields_array = array();
        $t_csv_fields_array['products_ean'] = 'Produktcode ';
        $t_csv_fields_array['products_model'] = 'Hersteller-ID';
        $t_csv_fields_array['products_id'] = 'Produkt-ID';
        $t_csv_fields_array['products_price'] = 'Preis';
        $t_csv_fields_array['products_currency'] = 'waehrung';
        $t_csv_fields_array['no_value'] = 'Steuer';
        $t_csv_fields_array['products_name'] = 'Bezeichner';
        $t_csv_fields_array['products_description'] = 'Beschreibung';
        $t_csv_fields_array['manufacturers_name'] = 'Marke';
        $t_csv_fields_array['products_link'] = 'Link_Produkt';
        $t_csv_fields_array['products_image_1'] = 'Link_Produktbild';
        $t_csv_fields_array['products_categories'] = 'Kategorieinformation';
        $t_csv_fields_array['products_shipping_costs'] = 'Versandkosten ';
        $t_csv_fields_array['products_shippingtime'] = 'Versandinformationen';
        $t_csv_fields_array['no_value'] = 'FSK';
        return($t_csv_fields_array);
    }

}

?>